/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Linky
 *
 * The Initial Developer of the Original Code is Henrik Gemal.
 * Portions created by the Initial Developer are Copyright (C) 2002-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Henrik Gemal <linky@gemal.dk> http://gemal.dk
 *   Jens Bannmann <jens.b@web.de>
 *   Jochen <autohide@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

// product related settings
// you can change these
const myProductName = "Mouse Gestures";
const myProductRegKey = "/mozdev/mozgest";

// ---- stuff for packaging script -----------------------------------------------------
// the packaging script is here: http://dev.mousegestures.org/build_mozgest.html
const myProductRegVersion = "1.5.2";
// -------------------------------------------------------------------------------------

const myJarFileName = "mozgest.jar";
const myJarCheckDupe = 1; // check if myJarFileName exist both in personal chrome folder and global chrome folder

// global settings
// dont change these
const sysChromeGlobal = getFolder("Chrome");
const sysChromeGlobalJar = getFolder("Chrome", myJarFileName);
const sysChromeUser = getFolder("Current User","chrome");
const sysChromeUserJar = getFolder("Current User", "chrome/" + myJarFileName);

function getMessage(key) {
  var msg = new String(Texts[key]);
  msg = new String(msg.replace(/%PRODUCT%/g, Texts.product));
  msg = new String(msg.replace(/%VERSION%/g, myProductRegVersion));
  return msg;
}

var err;
var err_tmp;
// init the installation
err_tmp = initInstall(myProductName, myProductRegKey, myProductRegVersion);
if (err_tmp) {
  err = err_tmp;
}

var doInstall = true;
var installToProfile;
var Texts = loadResources("install/install.properties");
var msg;

if (err) {
  logComment("Problem with initInstall(). Error code: " + err);
} else if (myJarCheckDupe && File.exists(sysChromeGlobalJar) && File.exists(sysChromeUserJar)) {
  var msg = getMessage("doubleinstall");
  msg = new String(msg.replace(/%PROFILE%/, sysChromeUserJar));
  msg = new String(msg.replace(/%GLOBAL%/, sysChromeGlobalJar));
  alert(msg);
  doInstall = false;
} else {
  // Can we install in the personal profile folder?
  if (buildID == 0 || buildID >= 2003030700) {
    if (File.exists(sysChromeGlobalJar) || File.exists(sysChromeUserJar)) {
      installToProfile = File.exists(sysChromeUserJar);
      msg = getMessage("existinglocation", false, false);
      msg = msg.replace(/%LOCATION%/, (installToProfile ? Texts.profilechrome
                                                        : Texts.globalchrome));
      if (confirm(msg) == 0) { // 0 = Cancel, 1 = OK
        doInstall = false;
      }
    } else {
      msg = getMessage("chooselocation");
      installToProfile = (confirm(msg) == 0); // 0 = Cancel, 1 = OK
    }
  } else {
    installToProfile = false;
  }
}

// did the user cancel, or did an error occur?
if (!doInstall || err) {
  cancelInstall();
} else {
  logComment(myProductName + " version " + myProductRegVersion + " being installed on " + buildID);
  logComment("Installing " + (installToProfile ? "to profile" : "globally"));

  // add the jar file
  if (!err) {
    err_tmp = addFile(myProductName, "chrome/" + myJarFileName,
                      (installToProfile ? sysChromeUser : sysChromeGlobal),
                      "");
    if (err_tmp) {
      logComment("Problem adding jar file. Error code: " + err_tmp);
      err = err_tmp;
    } else {
      logComment("ok adding jar file.");
    }
  }

  // add the component
  if (!err) {
    compDir = getFolder("Components");
    err_tmp = addFile ("mgMouseService.xpt", "1.0",
                       "components/mgIMouseService.xpt",compDir,"");
    if (err_tmp) {
      logComment("Problem adding component interface file. Error code: " + err_tmp);
      err = err_tmp;
    } else {
      logComment("ok adding component interface file.");
    }
    if (getWinRegistry())
    {
      err_tmp = addFile ("mgMouseService.dll", "1.0",
                         "platform/WINNT_x86-msvc/components/mgMouseService.dll",compDir,"");
      if (err_tmp) {
        logComment("Problem adding component file. Error code: " + err_tmp);
        err = err_tmp;
      } else {
        logComment("ok adding component file.");
      }
    }
    if (err) {
      alert(Texts.compError1);
      logComment("Continue installation without component. Sigh.");
      err = 0;
      resetError();
    }
  }

  // register the content
  if (!err) {
    if (installToProfile) {
      err_tmp = registerChrome(CONTENT | PROFILE_CHROME, sysChromeUserJar, "content/");
    } else {
      err_tmp = registerChrome(CONTENT | DELAYED_CHROME, sysChromeGlobalJar, "content/");
    }
    if (err_tmp) {
      logComment("Problem registering the content chrome. Error code: " + err_tmp);
      err = err_tmp;
    } else {
      logComment("ok registering the content chrome.");
    }
  }

  // register the locale
  if (!err) {
    if (installToProfile) {
      err_tmp = registerChrome(LOCALE | PROFILE_CHROME, sysChromeUserJar, "locale/en-US/mozgest/");
    } else {
      err_tmp = registerChrome(LOCALE | DELAYED_CHROME, sysChromeGlobalJar, "locale/en-US/mozgest/");
    }
    if (err_tmp) {
      logComment("Problem registering the locale chrome. Error code: " + err_tmp);
      err = err_tmp;
    } else {
      logComment("ok registering the locale chrome.");
    }
  }

  // register the skin
  if (!err) {
    if (installToProfile) {
      err_tmp = registerChrome(SKIN | PROFILE_CHROME, sysChromeUserJar, "skin/classic/mozgest/");
    } else {
      err_tmp = registerChrome(SKIN | DELAYED_CHROME, sysChromeGlobalJar, "skin/classic/mozgest/");
    }
    if (err_tmp) {
      logComment("Problem registering the skin chrome. Error code: " + err_tmp);
      err = err_tmp;
    } else {
      logComment("ok registering the skin chrome.");
    }
  }
  // do the install
  if (!err) {
    err_tmp = performInstall();
    if (err_tmp < 0) {
      logComment("Problem performing install. Error code: " + err_tmp);
      err = err_tmp;
    } else {
      alert(getMessage("success"));
    }
  }

  // did it work?
  if (err) {
    if (err == -202) {
      if (!File.exists(sysChromeGlobalJar)) {
        logComment("Problem installing. Error code: " + err +" Ask user for profile install");
           alert(getMessage("suggestprofileinstall"));
      } else {
        logComment("Problem installing. Error code: " + err +" Tell user the truth");
           alert(getMessage("noglobalinstall"));
        }
    } else {
      logComment("Problem installing. Error code: " + err + ". Error codes can been seen at: " + Texts.errorlist);
      var msg = getMessage("failure");
      msg = msg.replace(/%LINK%/, Texts.errorlist);
      alert(msg);
    }
    cancelInstall(err);
  }
}
